#include <iostream>
#include <algorithm>

const int total_max = 1000000000 + 7;

struct Zid{
    long long x, s;
    Zid(long long ax, long long as){
        x = ax;
        s = as;
    }
    Zid(){}
    operator< (const Zid& rhs){
        return x < rhs.x;
    }
    operator< (const int& rhs){
        return x < rhs;
    }
    operator< (const long long& rhs){
        return x < rhs;
    }
};

void ispis(Zid* arr, int N){
    std::cout << "---\n";
    for (int i = 0; i < N; i++){
        std::cout << arr[i].x << " " << arr[i].s << "\n";
    }
    std::cout << "---\n";
}

int main(){
    std::ios_base::sync_with_stdio(false);


    unsigned long long N;
    std::cin >> N;

    Zid* arr = new Zid[N];

    for (int i = 0; i < N; i++){
        long long x, s;
        std::cin >> x >> s;
        arr[i] = Zid(x, s);
    }

    std::sort(arr, arr + N);

    //ispis(arr, N);

    auto ilb = std::lower_bound(arr, arr + N, 0);
    Zid lb = *ilb;

    if (ilb == &arr[N]) {
        std::cout << 0 << "\n";
        return 0;
    }

    unsigned long long total = 0;
    long long ballx = 0;

    auto r = ilb;
    auto l = ilb - 1;

    while (true){
        bool no_more_left = (l == &arr[-1]);
        bool no_more_right = (r == &arr[N]);

        if (no_more_right) break;
        else if (no_more_left){
            total += (r->x - ballx);
            break;
        }

        unsigned long long bounces = std::min(l->s, r->s);

        total += (r->x - ballx) + (bounces * 2 - 1) * (r->x - l->x);

        //std::cout << ": bounces = " << bounces << " " << (r->x - ballx) << "+" << (bounces * 2 - 1) << "*" << (r->x - l->x) << "=" << (r->x - ballx) + (bounces * 2 - 1) * (r->x - l->x) << "\n";

        ballx = l->x;

        //std::cout << l->x << " " << r->x << " " << ballx << " " << total << "\n";

        r->s -= bounces;
        l->s -= bounces;

        if (r->s == 0) r++;
        if (l->s == 0) l--;
    }

    std::cout << total % total_max << "\n";

    delete[] arr;
    return 0;
}